 
;;########################################################################
;; misdsd5.lsp
;; Copyright (c) 1998 by Pedro Valero (valerop@uv.es)
;; Code for Visualization of Missing data 
;; Function to define the multiple boxplot in the visualization 
;; 
;;########################################################################



(defun bx-id (variables data-imputed-normal labels missing-by-var)
  (let* (
          
         (variables variables)
         (data (column-list data-imputed-normal))
         (point-labels  labels)
         (missing-by-var missing-by-var)
         
         )
   
    
    (setf plot-imputed-normal (boxplot data 
                                       :variable-labels variables
                                       :point-labels point-labels
                                       :connect-points t                                         
                                       :equate t
                                       :show nil
                                       )))
  (send plot-imputed-normal :title "Imputed Data")
  (send plot-imputed-normal :add-slot 'missing-by-var 
        missing-by-var)
  ;(send plot-imputed-normal :plot-buttons :new-x nil)
  (send plot-imputed-normal :connect-points t)

   
  (defmeth plot-imputed-normal :plot-help ()
    (plot-help-window (strcat "Help for " (send self :title)))
    (paste-plot-help (format nil "These boxplots show the data for the variables in the dataset. Each boxplot corresponds to the data available for this variable plus data estimated using the maximum likelihood matrix of correlations as parametters. Data estimated are red. Data that would be listwise deleted are green. Rest of the data for the variable are blue. The button named Select Missing in var shows a dialog with the list of variables in the data-set. Selecting one of them and pressing OK will highlight points in the plot that have been imputed for the variable. If the imputed data reveal themselves as very similar along the boxplots your missing data have probably similar characteristics and you are strongly recommended to make an effort towards getting further information about them. 
Note that if you decide to use the imputed data as data for further analysis you should use the option of Imputed data with random variate in the menu Create Data. This adds a random variable to the imputed data with an standard deviation equal to the estimation of the square mean error for each variable using the Maximum Likelihood matrix of parametters. However, no matter how impresive can look the previous method, this does not allow you to use imputed data as they were original data. Examine other methods in the statistical literature in case you are considering to use the imputed data for other purpose than exploration."))
      (show-plot-help))

  (setf miss-in-var-overlay (send graph-overlay-proto :new))

  (defmeth miss-in-var-overlay :location () (slot-value 'location))

  (let* (
         (ascent (send plot-imputed-normal :text-ascent))
         (x (+ 230 ascent))
         (y (round (* 1.3 ascent)))
         (box ascent))
    (send miss-in-var-overlay :add-slot 'location
          (list x y box (round (+ x (* 2.5 box))))))

  (defmeth miss-in-var-overlay :redraw ()
    (let* ((loc (send self :location))
           (x (first loc))
           (y (second loc))
           (box (third loc))
           (string-x (fourth loc))
           (graph (send self :graph)))
      (send graph :draw-color 'white)
      (send graph :paint-rect x (- y box) box box)
      (send graph :draw-color 'black)
      (send graph :frame-rect x (- y box) box box)
      (send graph :draw-string "Sel Miss Var" string-x y)))

(defmeth miss-in-var-overlay :do-click (x y m1 m2)
  (let* ((loc (send self :location))
         (box (third loc))
         (left (first loc))
         (top (- (second loc) box))
         (right (+ left box))
         (bottom (+ top box))
         (graph (send self :graph))
         )
    
    
    (when (and (< left x right) (< top y bottom))
          
          (send plot-imputed-normal :dialog)
          t)))


  (defmeth plot-imputed-normal :dialog ()
 
    (setf heading (send text-item-proto :new "Select Missing Values in Var"))
    (setf matlist (send list-item-proto :new (send plot-imputed-normal :variable-labels)))
    (setf cancel  (send modal-button-proto :new "Cancel" 
                      :action   #'(lambda ()
                                    (send lista-variables :close)
                                    )))
    (setf ok      (send modal-button-proto :new "Ok" 
                        :action   #'(lambda () 
                                                                      
                                      (send plot-imputed-normal 
                                            :select-red-in-boxplot 
                                            (send matlist :selection))
                                     
                                      (setf selection (send (aref 
                                                             (send matrix-comparecorr 
                                                                   :slot-value 'plot-matrix) 1 2) :selection))    
                                      (send matrix-comparecorr :update-low-row selection)
                                      
                                      (send lista-variables :close)
                                           )))
    (setf select-all      (send modal-button-proto :new "Select-all" 
                        :action   #'(lambda () 
                                                                      
                                      (send plot-imputed-normal 
                                            :select-red-in-boxplot 
                                            (send matlist :selection) :t)
                                     
                                      (setf selection (send (aref 
                                                             (send matrix-comparecorr 
                                                                   :slot-value 'plot-matrix) 1 2) :selection))    
                                      (send matrix-comparecorr :update-low-row selection)
                                      
                                      (send lista-variables :close)
                                           )))
    (setf lista-variables (send modal-dialog-proto :new
                              (list matlist select-all (list  ok cancel ))
                              :default-button ok))
    (send matlist :selection 0)) ;se asegura que este seleccionado algo
  
 

(send plot-imputed-normal :add-overlay miss-in-var-overlay)

        
(defmeth  plot-imputed-normal :missing-in-plot ()    
  (let* (
        (n (length 
            (first 
             (send self :data))))
        (nvars 
         (send self :num-var))
        (missing-by-var    (send self :slot-value 'missing-by-var))
        (missing-all (remove-duplicates (if missing-by-var (non-missing (combine missing-by-var)))))
        )       
       
    (dotimes (i nvars)
             (if missing-all
                 (send self
                       :point-color 
                       (+ missing-all (* i n))
                       'green))
             (if (select missing-by-var i)                      
                 (send self
                       :point-color 
                       (+ (select missing-by-var i) (* i n))
                       'RED))
                    
             )))


 (send plot-imputed-normal :missing-in-plot)

(defmeth plot-imputed-normal :select-red-in-boxplot (var &optional (all nil))
  (let*
    (
     (missing-by-var    (send self :slot-value 'missing-by-var))         
     (var var)
     (list-missing (remove-duplicates (if missing-by-var (non-missing (combine missing-by-var)))))
     
     )
    (cond
      (all 
       (if list-missing 
          
           (send self :selection list-missing)
           (send self :unselect-all-points))
       
       (if (not list-missing) (send self :change-plot)))
       
       (t
        (if (select missing-by-var var) 
        (send self :selection (select missing-by-var var))
        (send self :unselect-all-points))
        (if (not (select missing-by-var var)) (send self :change-plot)))
    )
    (send self :redraw)
     
   ))
 
  (defmeth plot-imputed-normal :redraw ()
    ;(send self :draw-color 'green)
    (send self :missing-in-plot)
    (call-next-method)

    )
plot-imputed-normal)
